<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use App\Movie;
use App\MovieComment;
use App\MovieSubcomment;
use App\TvSeries;
use Illuminate\Support\Facades\Log;



class QuickUpdateController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:movies.edit', ['only' => ['change']]);
        $this->middleware('permission:tvseries.edit', ['only' => ['changetvstatus']]);
        $this->middleware('permission:comment-settings.comments', ['only' => ['commentchange']]);
        $this->middleware('permission:comment-settings.subcomments', ['only' => ['subcomentchange']]);
    }
    public function change($id)
    {
        if (config('app.demolock') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }
        $movie = Movie::findorfail($id);

        if($movie->status == 1) {
            $movie->status = 0;
        } else {
            $movie->status = 1;
        }
        $movie->save();
        return back()->with('success', __('Movie Status changed !'));
    }

    public function changetvstatus($id)
    {
        if (config('app.demolock') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }

        $tv = TvSeries::findorfail($id);

        if ($tv->status == 1) {
            $tv->status = 0;
        } else {
            $tv->status = 1;
        }

        $tv->save();
        return back()->with('success', __('TvSeries Status changed !'));
    }

    public function commentchange($id)
    {
        if (config('app.demolock') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }
        $comment = MovieComment::findorfail($id);

        if ($comment->status == 1) {
            $comment->status = 0;
        } else {
            $comment->status = 1;
        }

        $comment->save();
        return back()->with('success', __('Comment Status changed !'));
    }
    public function free(Request $request, $id)
    {
        if (env('DEMO_LOCK') == 1) {
            Log::info('Free toggle attempt blocked due to demo lock.', [
                'movie_id' => $id,
                'user_id' => auth()->id()
            ]);
    
            return response()->json(['success' => false, 'message' => __('This action is disabled in the demo!')]);
        }
    
        try {
            $movie = Movie::findOrFail($id);
            $oldStatus = $movie->free;
            $movie->free = $request->free;
            $movie->save();
    
            Log::info('Movie free status updated.', [
                'movie_id' => $movie->id,
                'old_status' => $oldStatus,
                'new_status' => $movie->free,
                'user_id' => auth()->id()
            ]);
    
            return response()->json(['success' => true, 'message' => __('Updated Successfully!')]);
        } catch (\Exception $e) {
            Log::error('Error updating movie free status.', [
                'movie_id' => $id,
                'error' => $e->getMessage(),
                'user_id' => auth()->id()
            ]);
    
            return response()->json(['success' => false, 'message' => __('Error: ' . $e->getMessage())]);
        }
    }


    public function tv(Request $request,$id)
    {
        if (env('DEMO_LOCK') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }
        $tv = TvSeries::findorfail($id);
        try {
            $tv->free = $request->free; 
            $tv->save();
            return response()->json(['success' => true, 'message' => __('Updated Successfully!')]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => __('Error: ' . $e->getMessage())]);
        }
        
    }
    public function subcommentchange($id)
    {
        if (config('app.demolock') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }
        $comment = MovieSubcomment::findorfail($id);

        if ($comment->status == 1) {
            $comment->status = 0;
        } else {
            $comment->status = 1;
        }

        $comment->save();
        return back()->with('success', __('SubComment Status changed !'));
    }

}
